// === [Includes] ===
#include <a_samp>
#include <core>
#include <float>
#include <Dini>
#include <dudb>
#include <dutils>

// === [Color Defines] ===
#define COLOR_GREY 0xAFAFAFAA
#define COLOR_PURPLE 0xC2A2DAAA
#define COLOR_YELLOW 0xFFFF00AA
#define COLOR_WHITE 0xFFFFFFAA
#define COLOR_DBLUE 0x2641FEAA
#define COLOR_BLUE 0x33AAFFFF
#define COLOR_GREEN 0x33AA33AA
#define COLOR_ORANGE 0xFF9900AA
#define COLOR_GREY 0xAFAFAFAA
#define COLOR_GREEN 0x33AA33AA
#define COLOR_RED 0xFF0000FF
#define COLOR_LIGHTRED 0xFF6347AA
#define COLOR_LIGHTBLUE 0x33CCFFAA
#define COLOR_LIGHTGREEN 0x9ACD32AA
#define COLOR_YELLOW 0xFFFF00AA
#define COLOR_YELLOW2 0xF5DEB3AA
#define COLOR_WHITE 0xFFFFFFAA
#define COLOR_PURPLE 0xC2A2DAAA
#define COLOR_DBLUE 0x2641FEAA
#define COLOR_CYAN 0x00FFFFAA
#define COLOR_SYSTEM 0xEFEFF7AA


// === [Pragma] ===
#pragma unused ret_memcpy

// === [Forward] ===
forward IsStringAName(string[]);
forward GetPlayerID(string[]);
forward SendMessageToAdmins(color,const string[]);
forward Restart();
// === [Loops] ===
new Mute[MAX_PLAYERS];
new level[MAX_PLAYERS];
new aMessage[MAX_PLAYERS];
new freeze[MAX_PLAYERS];
new WarnedTimes[MAX_PLAYERS];
new logged[MAX_PLAYERS];


// === [Enum] ===
enum pInfo
{
    pAdmin,
}

new PlayerInfo[MAX_PLAYERS][pInfo];

public OnFilterScriptInit()
{
	print("  *****************************************************");
	print("  *| Andre's Administration Filterscript Version 0.5 |*");
	print("  *****************************************************");
}

// === [OnPlayerText] ===
public OnPlayerText(playerid,text[])
{
    if(Mute[playerid] == 1)
	{
		SendClientMessage(playerid, COLOR_RED, "     !");
		return 0;
    }
    if(Mute[playerid] == 0)
    {
		if(strfind(text, "Hack", true) == 0)
		{
		    SendClientMessageToAll(COLOR_RED, " /report [id] [reason]    !");
		}
		if(strfind(text, "noob", true) == 0)
		{
		    SendClientMessageToAll(COLOR_RED, "   !");
		}
		return 1;
	}
	return 0;
}


// === [OnPlayerConnect] ===
public OnPlayerConnect(playerid)
{
	new PlayerName[24];
    if(dini_Exists(udb_encode(PlayerName)))
	{
		SendClientMessage(playerid, COLOR_BLUE, "  , /register [password]");
	}
	else
	{
		SendClientMessage(playerid, COLOR_BLUE, " , /login [password]");
	}
	logged[playerid] = 0;
	freeze[playerid] = 0;
	return 1;
}

// === [OnPlayerCommandText] ===
public OnPlayerCommandText(playerid, cmdtext[])
{
    new cmd[256];
	new idx;
	new tmp[256];
	new giveplayer[MAX_PLAYER_NAME];
	new sendername[MAX_PLAYER_NAME];
	new string[256];
	new playername[256];
	new tmp2[256];
	cmd = strtok(cmdtext, idx);
	new giveplayerid;
// === [Getid] ===
	if(strcmp(cmd,"/getid",true) == 0 || strcmp(cmd, "/id", true) == 0)
	{
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp))
		{
			SendClientMessage(playerid,COLOR_DBLUE,"SERVER: /getid [part from the nick]");
			return 1;
		}
		format(string,sizeof(string),"Searched for: \"%s\": ",tmp);
		SendClientMessage(playerid,COLOR_RED,string);
		new found=0;
		for(new i=0; i <= MAX_PLAYERS; i++)
		{
			if(IsPlayerConnected(i))
			{
		  		new foundname[MAX_PLAYER_NAME];
		  		GetPlayerName(i, foundname, MAX_PLAYER_NAME);
				new namelen = strlen(foundname);
				new bool:searched=false;
		    	for(new pos=0; pos <= namelen; pos++)
				{
					if(searched != true)
					{
						if(strfind(foundname,tmp,true) == pos)
						{
			                found++;
							format(string,sizeof(string),"%d. %s (ID %d)",found,foundname,i);
							SendClientMessage(playerid, COLOR_GREEN ,string);
							searched = true;
						}
					}
				}
			}
		}
		return 1;
	}
// === [Register] ===
	if(strcmp(cmd, "/register", true) == 0)
	{
	    tmp = strtok(cmdtext, idx);
 		GetPlayerName(playerid, playername, sizeof(playername));
        if(20 < strlen(tmp) || strlen(tmp) < 4)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "Error!      4   20 !");
			return 1;
		}
	    if(!strlen(tmp))
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /register [password] ~ Will make You registered with the server!");

		else
		{
			if (!dini_Exists(udb_encode(playername)))
			{
				dini_Create(udb_encode(playername));
				dini_IntSet(udb_encode(playername), "password", udb_hash(tmp));
				dini_Set(udb_encode(playername),"pass",tmp);
    			dini_IntSet(udb_encode(playername), "level", 0);
				format(string, sizeof(string), "%s(%i) registered with password \"%s\"", playername, playerid, tmp);
				printf(string);
				format(string, sizeof(string), "Created account %s with password \"%s\". Please remember Your password!", playername, tmp);
				SendClientMessage(playerid, COLOR_PURPLE, string);
				SendClientMessage(playerid, COLOR_PURPLE, "Logged in!");
				logged[playerid] = 1;
				PlayerPlaySound(playerid,1057,0.0,0.0,0.0);
			}
			else
			{
			    SendClientMessage(playerid, COLOR_RED, "A error has occured while attempting to register with the server!");
				format(string, sizeof(string), "Username %s is already registered on this server!", playername,tmp);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}

		return 1;
	}
// === [Login] ===
	if(strcmp(cmd, "/login", true) == 0)
	{
		if(logged[playerid] == 1)
		{
		    SendClientMessage(playerid, COLOR_RED, "You already are logged in!");
		    return 1;
		}
	    tmp = strtok(cmdtext, idx);

 		GetPlayerName(playerid, playername, sizeof(playername));
	    if(!strlen(tmp))
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /login [password]");

		else
		{
			if(dini_Exists(udb_encode(playername)))
			{
					tmp2 = dini_Get(udb_encode(playername), "password");
			  		if(udb_hash(tmp) != strval(tmp2))
	  				{
	  				    new PlayerName[24];
	  				    GetPlayerName(playerid, PlayerName, 30);
	  				    format(string, sizeof(string), "Error! You have specified the wrong password for %s", PlayerName);
	  				    SendClientMessage(playerid, COLOR_RED, string);
					}
					else
					{
						logged[playerid] = 1;
						dini_Set(udb_encode(playername),"pass",tmp);
		                PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(playername), "level");
		                GameTextForPlayer(playerid, "~b~Successfully logged in!",2000,1);
		                PlayerPlaySound(playerid,1057,0.0,0.0,0.0);
		                if(PlayerInfo[playerid][pAdmin] == 0)
		                {
		                    new PlayerName[24];
	  				    	GetPlayerName(playerid, PlayerName, 30);
	  				    	format(string, sizeof(string), "Logged in as: %s, Regular member", PlayerName);
	  				    	SendClientMessage(playerid, COLOR_CYAN, string);
						}
		                if(PlayerInfo[playerid][pAdmin] == 1)
                  		{
                    		new PlayerName[24];
	  				    	GetPlayerName(playerid, PlayerName, 30);
	  				    	format(string, sizeof(string), "Logged in as: %s, Admin level 1 (moderator)", PlayerName);
	  				    	SendClientMessage(playerid, COLOR_CYAN, string);
						}
						if(PlayerInfo[playerid][pAdmin] == 2)
                  		{
                    		new PlayerName[24];
	  				    	GetPlayerName(playerid, PlayerName, 30);
	  				    	format(string, sizeof(string), "Logged in as: %s, Admin level 2 (administrator)", PlayerName);
	  				    	SendClientMessage(playerid, COLOR_CYAN, string);
						}
						if(PlayerInfo[playerid][pAdmin] == 3)
                  		{
                    		new PlayerName[24];
	  				    	GetPlayerName(playerid, PlayerName, 30);
	  				    	format(string, sizeof(string), "Logged in as: %s, Admin level 3 (Head administrator)", PlayerName);
	  				    	SendClientMessage(playerid, COLOR_CYAN, string);
						}
						if(PlayerInfo[playerid][pAdmin] == 4)
						{
						    new PlayerName[24];
	  				    	GetPlayerName(playerid, PlayerName, 30);
	  				    	format(string, sizeof(string), "Logged in as: %s, Admin level 4 (Server Owner)", PlayerName);
	  				    	SendClientMessage(playerid, COLOR_CYAN, string);
						}
						return 1;
					}
			}
			else
			{
			    format(string, sizeof(string), "The account %s, does not exist on this server. Please type /register [password] to create an account.", playername);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}

		return 1;
	}
// === [Adminhelp] ===
	if(strcmp(cmd, "/adminhelp", true) == 0)
	{
	    GetPlayerName(playerid, sendername, sizeof(sendername));
	    PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
	    if(PlayerInfo[playerid][pAdmin] >= 1)
	    {
	        new PlayerName[30];
	        GetPlayerName(playerid, PlayerName, 30);
			printf("[Command] %s has used /adminhelp & succeeded - The player is admin!", PlayerName);
	        SendClientMessage(playerid, COLOR_RED,"============================ Adminhelp ============================");
			if(PlayerInfo[playerid][pAdmin] == 1)
			{
				SendClientMessage(playerid, COLOR_YELLOW, "Level 1: /a(chat) | /clearchat | /kick [id] | /akill [id] | /warn [id] [reason]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 1: /(un)freeze [playerid] | /playerinfo [id] | /asay [msg] | /ip [id]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 1: /getid [name] | /ingite [id] [healthamount] | /mute [id]");
			}
			if(PlayerInfo[playerid][pAdmin] == 2)
			{
		 		SendClientMessage(playerid, COLOR_YELLOW, "Level 1: /a(chat) | /clearchat | /kick [id] | /akill [id] | /warn [id] [reason]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 1: /(un)freeze [playerid] | /playerinfo [id] | /asay [msg] | /ip [id]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 1: /getid [name] | /ingite [id] [healthamount] | /mute [id]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 2: /tele [teleportee id] [destination id] | /ban [id] | /announce [msg]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 2: /goto [id] | /gethere [id] | /eject [id] | /sethealth [id] [health]");
			}
			if(PlayerInfo[playerid][pAdmin] == 3)
			{
   				SendClientMessage(playerid, COLOR_YELLOW, "Level 1: /a(chat) | /clearchat | /kick [id] | /akill [id] | /warn [id] [reason]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 1: /(un)freeze [playerid] | /playerinfo [id] | /asay [msg] | /ip [id]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 1: /getid [name] | /ingite [id] [healthamount] | /mute [id]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 2: /tele [teleportee id] [destination id] | /ban [id] | /announce [msg]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 2: /goto [id] | /gethere [id] | /eject [id] | /sethealth [id] [health]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 3: /disarm [playerid] | /setadmin [id] [level] | /explode [id]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 3: /time [0-23] | /weather [weatherid]");
			}
			if(PlayerInfo[playerid][pAdmin] == 4)
			{
			    SendClientMessage(playerid, COLOR_YELLOW, "Level 1: /a(chat) | /clearchat | /kick [id] | /akill [id] | /warn [id] [reason]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 1: /(un)freeze [playerid] | /playerinfo [id] | /asay [msg] | /ip [id]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 1: /getid [name] | /ingite [id] [healthamount] | /mute [id]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 2: /tele [teleportee id] [destination id] | /ban [id] | /announce [msg]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 2: /goto [id] | /gethere [id] | /eject [id] | /sethealth [id] [health]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 3: /disarm [playerid] | /setadmin [id] [level] | /explode [id]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 3: /time [0-23] | /weather [weatherid]");
				SendClientMessage(playerid, COLOR_YELLOW, "Level 4: /restart | /disarmall");
			}
			return 1;
		}
		else
		{
		    new PlayerName[30];
		    GetPlayerName(playerid, PlayerName, 30);
			printf("[Command] %s has used /adminhelp & FAILED - The player isn't admin", PlayerName);
   			SendClientMessage(playerid, COLOR_CYAN, "You are not authorized to use this command!");
			return 1;
		}
	}
// === [Explode] ===
	if(strcmp(cmd, "/explode", true) == 0)
	{
	    GetPlayerName(playerid, sendername, sizeof(sendername));
	    PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /explode [playerid]");
			return 1;
		}
		if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You Must be logged in to use this command!");
		}
		GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
		if(PlayerInfo[playerid][pAdmin] >= 3)
		{
		    if(IsPlayerConnected(giveplayerid))
		    {
				format(string, sizeof(string), "AdmCMD: %s was exploded by %s",giveplayer, sendername);
				SendClientMessageToAll(COLOR_BLUE, string);
				SetPlayerHealth(giveplayerid, 10);
				new Float:boomx, Float:boomy, Float:boomz;
				GetPlayerPos(giveplayerid,boomx, boomy, boomz);
				CreateExplosion(boomx, boomy , boomz + 3, 7, 10);
				new PlayerName[30];
				GetPlayerName(playerid, PlayerName, 30);
				printf("[Command] %s has used /explode to explode %s", PlayerName, giveplayer);
			}
			else
			{
			    format(string, sizeof(string), "%d is not an active player.", giveplayerid);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		}
		return 1;
	}
// === [Asay] ===
	if(strcmp(cmd, "/asay", true) == 0)
	{
		GetPlayerName(playerid, sendername, sizeof(sendername));
		PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
	    if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You Must be logged in to use this command!");
		}
		new length = strlen(cmdtext);
		GetPlayerName(playerid, sendername, sizeof(sendername));
		while ((idx < length) && (cmdtext[idx] <= ' '))
		{
			idx++;
		}
		new offset = idx;
		new result[64];
		while ((idx < length) && ((idx - offset) < (sizeof(result) - 1)))
		{
			result[idx - offset] = cmdtext[idx];
			idx++;
		}
		result[idx - offset] = EOS;
		if(!strlen(result) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /asay [text]");
			return 1;
		}
		if(PlayerInfo[playerid][pAdmin] >= 1)
		{
			format(string, sizeof(string), "Admin %s: %s", sendername, result);
			SendClientMessageToAll(COLOR_BLUE,string);
			new PlayerName[30];
			GetPlayerName(playerid, PlayerName, 30);
			printf("[Command] %s has used /asay to send the message: %s", PlayerName, result);
     	}
		else
		{
			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
			return 1;
		}
		return 1;
	}
// === [Goto] ===
 	if(strcmp(cmd, "/goto", true) == 0)
	{
		GetPlayerName(playerid, sendername, sizeof(sendername));
	    PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp))
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /goto [playerid]");
			return 1;
		}
		new Float:plocx,Float:plocy,Float:plocz;
		if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You Must be logged in to use this command!");
		}
		if(PlayerInfo[playerid][pAdmin] >= 2)
		{
			if(IsPlayerConnected(giveplayerid))
			{
			    GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
				GetPlayerName(playerid, sendername, sizeof(sendername));
				format(string, sizeof(string), "AdmCMD: You teleported Yourself to %s(%i)", giveplayer, giveplayerid);
				SendClientMessage(playerid, COLOR_BLUE, string);
				GetPlayerPos(giveplayerid, plocx, plocy, plocz);
				new intid = GetPlayerInterior(giveplayerid);
				SetPlayerInterior(playerid,intid);
				new PlayerName[30];
				GetPlayerName(playerid, PlayerName, 30);
				printf("[Command] %s has used /goto to go to %s", PlayerName, giveplayer);
				if (GetPlayerState(playerid) == 2)
				{
					new tmpcar = GetPlayerVehicleID(playerid);
					SetVehiclePos(tmpcar, plocx, plocy+4, plocz);
				}
				else
				{
						SetPlayerPos(playerid,plocx,plocy+2, plocz);
				}
			}
			else
			{
			    format(string, sizeof(string), "%d is not an active player.", giveplayerid);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		}
		return 1;
	}
// === [Gethere] ===
	if(strcmp(cmd, "/gethere", true) == 0)
	{
	    GetPlayerName(playerid, sendername, sizeof(sendername));
	    PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp))
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /gethere [playerid]");
			return 1;
		}
		new Float:plocx,Float:plocy,Float:plocz;
		if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You Must be logged in to use this command!");
		}
		if(PlayerInfo[playerid][pAdmin] >= 2)
		{
		    if(IsPlayerConnected(giveplayerid))
		    {
			    GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
				GetPlayerName(playerid, sendername, sizeof(sendername));
				format(string, sizeof(string), "AdmCMD: You were teleported to %s(%i)",sendername,playerid);
				SendClientMessage(giveplayerid, COLOR_BLUE, string);
				format(string, sizeof(string), "AdmCMD: You teleported %s(%i) to Yourself", giveplayer, giveplayerid);
				SendClientMessage(playerid, COLOR_BLUE, string);
				GetPlayerPos(playerid, plocx, plocy, plocz);
				new intid = GetPlayerInterior(playerid);
				SetPlayerInterior(giveplayerid,intid);
				new PlayerName[30];
				GetPlayerName(playerid, PlayerName, 30);
				printf("[Command] %s has used /gethere to get %s", PlayerName, giveplayer);

				if (GetPlayerState(giveplayerid) == 2)
				{
					new tmpcar = GetPlayerVehicleID(giveplayerid);
					SetVehiclePos(tmpcar, plocx, plocy+4, plocz);
				}
				else
				{
						SetPlayerPos(giveplayerid,plocx,plocy+2, plocz);
				}
			}
			else
			{
                format(string, sizeof(string), "%d is not an active player.", giveplayerid);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		}
		return 1;
	}
// === [Time] ===
	if(strcmp(cmd, "/time", true) == 0)
	{
	    GetPlayerName(playerid, sendername, sizeof(sendername));
	    PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp))
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /time [0-23]");
			return 1;
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You Must be logged in to use this command!");
		}
		new time;
		time = strval(tmp);
		GetPlayerName(playerid, sendername, sizeof(sendername));
		if(PlayerInfo[playerid][pAdmin] >= 3)
		{
		    if(time > 23)
			{
				SendClientMessage(playerid, COLOR_RED, "Invalid time! 0 - 23!");
			}
			else
			{
	            SetWorldTime(time);
				format(string, sizeof(string), "AdmCMD: Admin %s set the time to: %d",sendername,time);
				SendClientMessageToAll(COLOR_BLUE, string);
				new PlayerName[30];
				GetPlayerName(playerid, PlayerName, 30);
				printf("[Command] %s has used /time to set time to: %s", PlayerName, time);
			}
		}
		else
		{
			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		}
		return 1;
	}
// === [Weather] ===
	if(strcmp(cmd, "/weather", true) == 0)
	{
	    GetPlayerName(playerid, sendername, sizeof(sendername));
		PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp))
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /weather [weather]");
			SendClientMessage(playerid, COLOR_DBLUE, "Weather IDs: /weatherids");
			return 1;
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You Must be logged in to use this command!");
		}
		new weather;
		weather = strval(tmp);
		GetPlayerName(playerid, sendername, sizeof(sendername));
		if(PlayerInfo[playerid][pAdmin] >= 3)
		{
            SetWeather(weather);
			format(string, sizeof(string), "AdmCMD: Admin %s set the weather to: %d",sendername,weather);
			SendClientMessageToAll(COLOR_BLUE, string);
			SendClientMessage(playerid, COLOR_DBLUE, "See wheater IDs at: /weatherids");
			new PlayerName[30];
			GetPlayerName(playerid, PlayerName, 30);
			printf("[Command] %s has used /weather to set weather to: %s", PlayerName, weather);
		}
		else
		{
			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		}
		return 1;
	}
// === [Weatherids] ===
 	if(strcmp(cmd, "/weatherids", true) == 0 || strcmp(cmd, "/weathers", true) == 0)
	{
	    GetPlayerName(playerid, sendername, sizeof(sendername));
		PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		if(PlayerInfo[playerid][pAdmin] >= 3)
		{
			SendClientMessage(playerid, COLOR_RED, ">>+-=================================== [Weather Ids: ] ================================");
			SendClientMessage(playerid, COLOR_YELLOW, ">>| 1 - Blue | 2 - Lighter Blue | 3 - Light (No color) | 4 - Even more lighter");
			SendClientMessage(playerid, COLOR_YELLOW, ">>| 5 - Normal Sun | 7 - (My PC = Beeped) | 8 - Rainy | 9 - Foggy | 10 - Standard weather");
			SendClientMessage(playerid, COLOR_YELLOW, ">>| 12 - Colourless, with alittle fog | 13 - Less foggy  | 15 - Little fog ");
			SendClientMessage(playerid, COLOR_YELLOW, ">>| 16 - Rainy | 17 - Hot | 19 - Sandstorm | 20 - Dark | 21 - Some very wierd weather ");
			SendClientMessage(playerid, COLOR_YELLOW, ">>| 23 - Atmosphere style (?) | 25 - Abit foggy | 27 - Abit \"White\" | 30 - Thunderstorm ");
			SendClientMessage(playerid, COLOR_YELLOW, ">>| 32 - Foggy | 33 - Hot | 35 - City weather | 37 - Warm | 38 - Even more city weather ");
			SendClientMessage(playerid, COLOR_YELLOW, ">>| 39 - Industrial weather | 40 - Yellow weather | 42 - Black fog | 43 - Industrial fog ");
			SendClientMessage(playerid, COLOR_YELLOW, ">>| 44 & 45 - Some wierd weather. -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- (c) IDs by PaoloP");
			SendClientMessage(playerid, COLOR_RED, ">>+-====================================================================================");
		}
		else
		{
		    SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		}
		return 1;
	}
// === [Slap] ===
 	if(strcmp(cmd, "/slap", true) == 0)
	{
	    GetPlayerName(playerid, sendername, sizeof(sendername));
	    PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp))
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /slap [playerid]");
			return 1;
		}
		new Float:health;
		new Float:px, Float:py, Float:pz;
		if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You Must be logged in to use this command!");
		}
		GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
		if(PlayerInfo[playerid][pAdmin] >= 1)
		{
		    if(IsPlayerConnected(giveplayerid))
		    {
				GetPlayerHealth(giveplayerid, health);
				SetPlayerHealth(giveplayerid, health-5);
				GetPlayerPos(giveplayerid, px, py, pz);
				SetPlayerPos(giveplayerid, px, py, pz+5);
				format(string, sizeof(string), "AdmCMD: %s was slapped by %s",giveplayer, sendername);
				SendClientMessageToAll(COLOR_BLUE, string);
				new PlayerName[30];
				GetPlayerName(playerid, PlayerName, 30);
				printf("[Command] %s has used /slap to slap %s", PlayerName, giveplayer);
			}
			else
			{
			    format(string, sizeof(string), "%d is not an active player.", giveplayerid);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		}
		return 1;
	}
// === [Eject] ===
	if(strcmp(cmd,"/eject",true) == 0)
	{
	    GetPlayerName(playerid, sendername, sizeof(sendername));
	    PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
	    GetPlayerName(playerid, sendername, sizeof(sendername));
	    GetPlayerName(giveplayerid, giveplayer, sizeof(sendername));
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp))
		{
			SendClientMessage(playerid,COLOR_DBLUE,"SERVER: /eject [playerid]");
			return 1;
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You Must be logged in to use this command!");
		}
		if(IsStringAName(tmp))
		{
		    giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(PlayerInfo[playerid][pAdmin] >= 2)
		{
			if(IsPlayerConnected(giveplayerid))
			{
			    if(IsPlayerInAnyVehicle(giveplayerid))
			    {
			        RemovePlayerFromVehicle(giveplayerid);
			        format(string, sizeof(string), "Administrator %s has ejected You!", sendername);
			        SendClientMessage(giveplayerid, COLOR_RED, string);
			        format(string, sizeof(string), "AdmCMD: %s has been ejected by %s", giveplayer, sendername);
			        SendClientMessageToAll(COLOR_BLUE, string);
			        new PlayerName[30];
					GetPlayerName(playerid, PlayerName, 30);
					printf("[Command] %s has used /eject to eject %s", PlayerName, giveplayer);
			        return 1;
				}
				else
				{
					format(string, sizeof(string), "Error! %s isn't in a vehicle!");
					SendClientMessage(playerid, COLOR_RED, string);
					return 1;
				}
			}
			else
			{
			    format(string, sizeof(string), "%d is not an active player.", giveplayerid);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
		    SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		}
		    
		return 1;
	}
// === [Sethealth] ===
	if(strcmp(cmd,"/sethealth",true) == 0)
	{
	    GetPlayerName(playerid, sendername, sizeof(sendername));
	    PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		new health;
		GetPlayerName(playerid, sendername, sizeof(sendername));
		GetPlayerName(giveplayerid, giveplayer,sizeof(giveplayer));
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp))
		{
			SendClientMessage(playerid,COLOR_DBLUE,"SERVER: /sethealth [id] [health]");
			return 1;
		}
		if(IsStringAName(tmp))
		{
		    giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You Must be logged in to use this command!");
		}
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp))
		{
			SendClientMessage(playerid,COLOR_DBLUE,"SERVER: /sethealth [id] [health]");
			return 1;
		}
		health = strval(tmp);
		if(health < 0 || health > 100)
		{
		    SendClientMessage(playerid,COLOR_RED,"ERROR: Invalid health.");
		    return 1;
		}
		if(PlayerInfo[playerid][pAdmin] >= 2)
		{
			if(IsPlayerConnected(giveplayerid))
			{
    			SetPlayerHealth(giveplayerid,health);
				format(string,sizeof(string),"AdmCMD: You have been set %s's health to %d",giveplayer, health);
				SendClientMessage(playerid,COLOR_RED,string);
				format(string,sizeof(string),"AdmCMD: Admin %s set your health to %d",sendername, health);
				SendClientMessage(giveplayerid,COLOR_RED,string);
				new PlayerName[30];
				GetPlayerName(playerid, PlayerName, 30);
				printf("[Command] %s has used /sethealth to set %s's health to: %d", PlayerName, giveplayer, health);
			}
			else
			{
			    format(string, sizeof(string), "%d is not an active player.", giveplayerid);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
		    SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		}
		return 1;
	}
// === [Playerinfo] ===
	if(strcmp(cmd, "/playerinfo", true) == 0 || strcmp(cmd, "/stats", true) == 0)
	{
	    GetPlayerName(playerid, sendername, sizeof(sendername));
	    PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /playerinfo [playerid]");
			return 1;
		}
		if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You Must be logged in to use this command!");
		}
		GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
		if(PlayerInfo[playerid][pAdmin] >= 1)
		{
			if(IsPlayerConnected(giveplayerid))
			{
			    new Float:health;
			    new Float:armour;
				new intr = GetPlayerInterior(giveplayerid);
				GetPlayerHealth(giveplayerid,health);
				GetPlayerArmour(giveplayerid,armour);
				new ammo = GetPlayerAmmo(giveplayerid);
				new score = GetPlayerScore(giveplayerid);
				new skin = GetPlayerSkin(giveplayerid);
				new money = GetPlayerMoney(giveplayerid);
				new playerip[256];
				GetPlayerIp(giveplayerid, playerip, sizeof(playerip));
				new ping = GetPlayerPing(giveplayerid);
				if(logged[giveplayerid] == 0)
				{
					format(string, sizeof(string),"Information on player %s (ID: %i)(Player isn't logged in) :",giveplayer, giveplayerid);
					SendClientMessage(playerid, COLOR_BLUE, string);
				}
				else
				{
					format(string, sizeof(string),"Information on player %s (ID: %i) :",giveplayer, giveplayerid);
					SendClientMessage(playerid, COLOR_BLUE, string);
				}
				format(string, sizeof(string), "Health [%.1f] | Armour [%.1f] | Money [%d] | Interior [%d] | IP [%s]",health, armour, money, intr,playerip);
				SendClientMessage(playerid, COLOR_RED,string);
				format(string, sizeof(string), "Ammo [%d] | Score[%d] | Skin [%d] | Ping [%d] | Times Warned: %d",ammo, score, skin, ping, WarnedTimes);
				SendClientMessage(playerid, COLOR_RED,string);
				new PlayerName[30];
				GetPlayerName(playerid, PlayerName, 30);
				printf("[Command] %s has used /playerinfo to see information on player %s", PlayerName, giveplayer);
			}
			else
			{
			    format(string, sizeof(string), "%d is not an active player.", giveplayerid);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
            SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
            return 1;
		}
		return 1;
	}
	if(strcmp(cmd, "/restart", true) == 0 || strcmp(cmd, "/gmx", true) == 0)
	{
	    if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You Must be logged in to use this command!");
		}
	    if(PlayerInfo[playerid][pAdmin] == 4)
	    {
	        format(string, sizeof(string), "AdmCMD: %s has restarted the server, please wait");
	        SendClientMessageToAll(COLOR_RED, string);
	        SetTimerEx("Restart", 5000, 0, "i", playerid);
			new PlayerName[30];
			GetPlayerName(playerid, PlayerName, 30);
			printf("[Command] %s has used /restart to restart the server", PlayerName);
		}
		else
		{
		    SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		}
		return 1;
	}
// === [IP] ===
	if(strcmp(cmd, "/ip", true) == 0)
	{
	    GetPlayerName(playerid, sendername, sizeof(sendername));
	    PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
	    tmp = strtok(cmdtext, idx);
		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /ip [playerid]");
			return 1;
		}
		if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You Must be logged in to use this command!");
		}
		GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
		if(PlayerInfo[playerid][pAdmin] >= 1)
		{
		    if(IsPlayerConnected(giveplayerid))
		    {
				new playerip[256];
				GetPlayerIp(giveplayerid, playerip, sizeof(playerip));
				format(string, sizeof(string),"AdmCMD: Checked IP on %s(%i): %s ",giveplayer, giveplayerid, playerip);
				SendClientMessage(playerid, COLOR_BLUE, string);
				new PlayerName[30];
				GetPlayerName(playerid, PlayerName, 30);
				printf("[Command] %s has used /ip to check %s's IP", PlayerName, giveplayer);
			}
			else
			{
			    format(string, sizeof(string), "%d is not an active player.", giveplayerid);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
            SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
            return 1;
		}
		return 1;
	}
// === [Givemoney] ===
	if(strcmp(cmd, "/givemoney", true) == 0)
	{
	    GetPlayerName(playerid, sendername, sizeof(sendername));
	    PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 3)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /givemoney [playerid] [amount]");
			return 1;
		}
		new money;
		if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You must be logged in to use this command!");
			return 1;
		}
		tmp = strtok(cmdtext, idx);
		money = strval(tmp);
		GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
		if(PlayerInfo[playerid][pAdmin] >= 3)
		{
			GivePlayerMoney(giveplayerid, money);
			format(string, sizeof(string), "AdmCMD: You sent %s(%i) $%d", giveplayer,giveplayerid, money);
			SendClientMessage(playerid,COLOR_BLUE, string);
			format(string, sizeof(string), "AdmCMD: You received $%d from Admin %s", money,sendername);
			SendClientMessage(giveplayerid,COLOR_BLUE, string);
			new PlayerName[30];
			GetPlayerName(playerid, PlayerName, 30);
			printf("[Command] %s has used /givemoney to give %s $%s", PlayerName, giveplayer, money);
		}
		else
		{
            SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
 			return 1;
		}
		return 1;
	}
// === [Kick] ===
	if(strcmp(cmd, "/kick", true) == 0)
	{
		tmp = strtok(cmdtext, idx);
		giveplayerid = strval(tmp);
		GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
        PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
        PlayerInfo[giveplayerid][pAdmin] = dini_Int(udb_encode(giveplayer), "level");
        if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /kick [playerid]");
			return 1;
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You must be logged in to use this command!");
			return 1;
		}
		if(PlayerInfo[playerid][pAdmin] >= 1)
		{
		    if(IsPlayerConnected(giveplayerid))
		    {
		        GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
				GetPlayerName(playerid, sendername, sizeof(sendername));
				format(string, sizeof(string), "Admin %s kicked %s (id: %d).", sendername,giveplayer,giveplayerid);
				SendClientMessageToAll(COLOR_BLUE,string);
				Kick(giveplayerid);
				new PlayerName[30];
				GetPlayerName(playerid, PlayerName, 30);
				printf("[Command] %s has used /kick to kick %s", PlayerName, giveplayer);
				return 1;
			}
			else
			{
				format(string, sizeof(string), "%d is not an active player.", giveplayerid);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
 			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
 			return 1;
		}
		return 1;
	}
// === [Warn] ===
	if(strcmp(cmd, "/warn", true) == 0)
	{
		new str[256];
		tmp = strtok(cmdtext, idx);
		tmp2 = strtok(cmdtext, idx);

		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /warn [PlayerID] [Reason]");
			return 1;
		}
		if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		giveplayerid = strval(tmp);
		if(PlayerInfo[playerid][pAdmin] >= 1)
		{
			if(WarnedTimes[giveplayerid] == 0)
			{
				WarnedTimes[giveplayerid]+=1;
				GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
				GetPlayerName(playerid, sendername, sizeof (sendername));
				format(str, sizeof (str), "AdmCMD: %s was warned by %s for: %s [1/3 Warnings]", giveplayer, sendername, cmdtext[8]);
				SendClientMessageToAll(COLOR_BLUE, str);
				print(str);
				return 1;
			}
			if(WarnedTimes[giveplayerid] == 1)
			{
			    WarnedTimes[giveplayerid]+=1;
				GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
				GetPlayerName(playerid, sendername, sizeof (sendername));
				format(str, sizeof (str), "AdmCMD: %s was warned by %s for: %s [2/3 Warnings]", giveplayer, sendername, cmdtext[8]);
				SendClientMessageToAll(COLOR_BLUE, str);
				print(str);
				return 1;
			}
			else if(WarnedTimes[giveplayerid] == 2)
			{
				GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
				GetPlayerName(playerid, sendername, sizeof (sendername));
				format(str, sizeof (str), "AdmCMD: %s was kicked by %s for: %s [3/3 Warnings]", giveplayer, sendername, cmdtext[8]);
				SendClientMessageToAll(COLOR_BLUE, str);
				Kick(giveplayerid);
				return 1;
			}
		}
		else
		{
			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
			return 1;
		}
	}
// === [Freeze] ===
	if(strcmp(cmd, "/freeze", true) == 0)
	{
		tmp = strtok(cmdtext, idx);
		giveplayerid = strval(tmp);
		GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
        PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
        PlayerInfo[giveplayerid][pAdmin] = dini_Int(udb_encode(giveplayer), "level");
        if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You must be logged in to use this command!");
			return 1;
		}
		if(PlayerInfo[playerid][pAdmin] >= 1)
		{
		    if(IsPlayerConnected(giveplayerid))
		    {
		        if(freeze[giveplayerid] == 1)
		        {
		            SendClientMessage(playerid, COLOR_RED, "The player is already frozen!");
		            return 1;
				}
				else
				{
			        freeze[giveplayerid] = 1;
					GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
					GetPlayerName(playerid, sendername, sizeof(sendername));
					TogglePlayerControllable(giveplayerid, 0);
					format(string, sizeof(string), "AdmCMD: %s was frozen by %s.",giveplayer, sendername);
					SendClientMessageToAll(COLOR_BLUE, string);
					new PlayerName[30];
					GetPlayerName(playerid, PlayerName, 30);
					printf("[Command] %s has used /freeze to freeze %s", PlayerName, giveplayer);
					return 1;
				}
			}
			else
			{
			    format(string, sizeof(string), "%d is not an active player.", giveplayerid);
				SendClientMessage(playerid, COLOR_BLUE, string);
			}
		}
		else
		{
 			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
 			return 1;
		}
		return 1;
	}
// === [Unfreeze] ===
	if(strcmp(cmd, "/unfreeze", true) == 0)
	{
		tmp = strtok(cmdtext, idx);
		giveplayerid = strval(tmp);
		GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
        PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
        PlayerInfo[giveplayerid][pAdmin] = dini_Int(udb_encode(giveplayer), "level");
        if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You must be logged in to use this command!");
			return 1;
		}
		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /unfreeze [playerid]");
			return 1;
		}
		if(PlayerInfo[playerid][pAdmin] >= 1)
		{
		    if(IsPlayerConnected(giveplayerid))
		    {
		        if(freeze[giveplayerid] == 1)
		        {
	      			GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
					GetPlayerName(playerid, sendername, sizeof(sendername));
					TogglePlayerControllable(giveplayerid, 1);
					freeze[giveplayerid] = 0;
					format(string, sizeof(string), "AdmCMD: %s was thawed by %s", giveplayer,sendername);
					SendClientMessageToAll(COLOR_BLUE, string);
					new PlayerName[30];
					GetPlayerName(playerid, PlayerName, 30);
					printf("[Command] %s has used /unfreeze to unfreeze(thaw) %s", PlayerName, giveplayer);
					return 1;
				}
				else
				{
				    SendClientMessage(playerid, COLOR_RED, "This player can't be thawed, he already is!");
				    return 1;
				}
			}
			else
			{
			    format(string, sizeof(string), "%d is not an active player.", giveplayerid);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
 			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
 			return 1;
		}
		return 1;
	}
// === [Setadmin] ===
	if(strcmp(cmd, "/setadmin", true) == 0 || strcmp(cmd, "/setlevel", true) == 0)
	{
		tmp = strtok(cmdtext, idx);
		giveplayerid = strval(tmp);
		GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
		PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		PlayerInfo[giveplayerid][pAdmin] = dini_Int(udb_encode(giveplayer), "level");
		if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /setadmin [playerid] [level]");
			return 1;
		}
		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /setadmin [playerid] [level]");
			return 1;
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You must be logged in to use this command!");
			return 1;
		}
		PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		level[playerid] = strval(tmp);
		if(level[playerid] < 0)
		{
			SendClientMessage(playerid, COLOR_RED, "Invalid Admin Level");
            return 1;
		}
		if(level[playerid] > 4)
		{
			SendClientMessage(playerid, COLOR_RED, "Invalid Admin Level");
            return 1;
		}
		if(level[playerid] == PlayerInfo[giveplayerid][pAdmin])
		{
            format(string, sizeof(string), "That player already has level %d admin privileges.", level[playerid]);
            SendClientMessage(playerid, COLOR_BLUE, string);
            return 1;
		}
		if(IsPlayerAdmin(playerid) || PlayerInfo[playerid][pAdmin] >= 3)
		{
		    if(IsPlayerConnected(giveplayerid))
		    {
		        if(logged[giveplayerid] == 0)
				{
					SendClientMessage(playerid, COLOR_RED, "The player You're setting rights to must be logged in!");
					return 1;
				}
				else
				{
					GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
					GetPlayerName(playerid, sendername, sizeof(sendername));
					dini_IntSet(udb_encode(giveplayer), "level", level[playerid]);
					format(string, sizeof(string), "You have given %s level %d admin powers.", giveplayer, level[playerid]);
					SendClientMessage(playerid, COLOR_BLUE, string);
					format(string, sizeof(string), "You were made a level %d admin by %s (id: %d).", level[playerid], sendername, playerid);
					SendClientMessage(giveplayerid, COLOR_BLUE, string);
					PlayerInfo[giveplayerid][pAdmin] = dini_Int(udb_encode(giveplayer), "level");
					new PlayerName[30];
					GetPlayerName(playerid, PlayerName, 30);
					printf("[Command] %s has used /setadmin to set %s ' level to: %d", PlayerName, giveplayer, level[playerid]);
				}
			}
			else
			{
			    format(string, sizeof(string), "%d is not an active player ID number.", giveplayerid);
            	SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		}
		return 1;
	}
	if(strcmp(cmd, "/setmeadmin", true) == 0)
	{
	    if(logged[playerid] == 1)
	    {
		    if(IsPlayerAdmin(playerid))
		    {
				GetPlayerName(playerid, sendername, sizeof(sendername));
		        level[playerid] = 4;
		        level[playerid] = dini_Int(udb_encode(sendername), "level");
		        PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		        level[playerid] = PlayerInfo[playerid][pAdmin];
		        SendClientMessage(playerid, COLOR_RED, "You've set Your level to 4, Server Owner");
		        SendClientMessage(playerid, COLOR_RED, "Check out /adminhelp for administration commands.");
			}
			else
			{
			    SendClientMessage(playerid, COLOR_RED, "You have to be RCON admin to set Yourself admin!");
			}
			return 1;
		}
		else
		{
		    SendClientMessage(playerid, COLOR_RED, "You must be logged in!");
		}
		return 1;
	}
    
// === [Ban] ===
	if(strcmp(cmd, "/ban", true) == 0)
	{
		tmp = strtok(cmdtext, idx);
		giveplayerid = strval(tmp);
		GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
        PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
        PlayerInfo[giveplayerid][pAdmin] = dini_Int(udb_encode(giveplayer), "level");
        if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /ban [playerid]");
			return 1;
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You must be logged in to use this command!");
			return 1;
		}

		if(PlayerInfo[playerid][pAdmin] >= 2)
		{
		    if(IsPlayerConnected(giveplayerid))
		    {
		    	GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
				GetPlayerName(playerid, sendername, sizeof(sendername));
				format(string, sizeof(string), "AdmCMD: %s was banned by %s.",giveplayer,sendername);
				SendClientMessageToAll(COLOR_BLUE,string);
				format(string, sizeof(string), "AdmCMD: You were banned by %s (id: %d).", sendername);
				SendClientMessage(giveplayerid, COLOR_BLUE, string);
				new PlayerName[30];
				GetPlayerName(playerid, PlayerName, 30);
				printf("[Command] %s has used /ban to ban %s", PlayerName, giveplayer);
				Ban(giveplayerid);
			}
			else
			{
                format(string, sizeof(string), "%d is not an active player.", giveplayerid);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
  			if(PlayerInfo[playerid][pAdmin] == 1)
  			{
  				SendClientMessage(playerid, COLOR_RED, "You are administrator level 1. Level 2 rights are required to execute /ban");
			}
			else
			{
				SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
			}
  			return 1;
		}
		return 1;
	}
// === [Mute] ===
	if(strcmp(cmd, "/mute", true) == 0)
	{
	    GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
        PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
        PlayerInfo[giveplayerid][pAdmin] = dini_Int(udb_encode(giveplayer), "level");
		tmp = strtok(cmdtext, idx);
		if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /mute [ID]");
			return 1;
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You must be logged in to use this command!");
			return 1;
		}
		if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
		if(PlayerInfo[playerid][pAdmin] >= 1)
		{
			if(IsPlayerConnected(giveplayerid))
			{
				if(Mute[giveplayerid] == 0)
				{
					Mute[giveplayerid] = 1;
					format(string, sizeof(string), "AdmCMD: %s was muted by %s",giveplayer ,sendername);
					SendClientMessageToAll(COLOR_BLUE, string);
					new PlayerName[30];
					GetPlayerName(playerid, PlayerName, 30);
					printf("[Command] %s has used /mute to mute %s", PlayerName, giveplayer);
				}
				else
				{
					Mute[giveplayerid] = 0;
					format(string, sizeof(string), "AdmCMD: %s was un-muted by %s",giveplayer ,sendername);
					SendClientMessageToAll(COLOR_BLUE, string);
					new PlayerName[30];
					GetPlayerName(playerid, PlayerName, 30);
					printf("[Command] %s has used /mute to unmute %s", PlayerName, giveplayer);
				}
			}
			else
			{
				format(string, sizeof(string), "%d is not an active player.", giveplayerid);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
 			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
 			return 1;
		}
		return 1;
	}
// === [Announce] ===
	if(strcmp(cmd, "/announce", true) == 0 || strcmp(cmd, "/ann", true) == 0)
	{

        tmp = strtok(cmdtext, idx, strlen(cmdtext));
		GetPlayerName(playerid, sendername, sizeof(sendername));
        PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
        PlayerInfo[giveplayerid][pAdmin] = dini_Int(udb_encode(giveplayer), "level");
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You must be logged in to use this command!");
			return 1;
		}
		PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		/*if(PlayerInfo[playerid][pAdmin] == 0)
		{
		    SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		    return 1;
		}*/
 		if (!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 2)
  		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /announce [message]");
 			return 1;
      	}
		if(PlayerInfo[playerid][pAdmin] >= 2)
		{
  			format(string, sizeof(string), "~r~%s", tmp);
			GameTextForAll(string, 5000, 3);
			new PlayerName[30];
 			GetPlayerName(playerid, PlayerName, 30);
			printf("[Command] %s has used /announce", PlayerName);
			for(new i=0;i<MAX_PLAYERS;i++)
			{
				if(IsPlayerConnected(i))
				{
		    		aMessage[i] = 1;
		    		SetTimer("announcer",5000,0);
				}
			}
		}
 		else
  		{
   			if(PlayerInfo[playerid][pAdmin] == 1)
			{
				SendClientMessage(playerid, COLOR_RED, "You are administrator level 1. Level 2 rights are required to execute /announce");
			}
			else
			{
 				SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
			}
  			return 1;
		}
        return 1;
	}
// === [Akill] ===
	if(strcmp(cmd, "/akill", true) == 0)
	{
		tmp = strtok(cmdtext, idx);
		giveplayerid = strval(tmp);
		GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
        PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
        PlayerInfo[giveplayerid][pAdmin] = dini_Int(udb_encode(giveplayer), "level");
        if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You must be logged in to use this command!");
			return 1;
		}
		if(PlayerInfo[playerid][pAdmin] < 1)
		{
		    SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		    return 1;
		}
		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "SERVER: /akill [playerid]");
			return 1;
		}
		if(PlayerInfo[playerid][pAdmin] >= 1)
		{
		    if(IsPlayerConnected(giveplayerid))
		    {
		    	GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
				GetPlayerName(playerid, sendername, sizeof(sendername));
				SetPlayerHealth(giveplayerid, -999);
				format(string, sizeof(string), "AdmCMD: You have murdered %s.", giveplayer);
				SendClientMessage(playerid, COLOR_BLUE, string);
				new PlayerName[30];
				GetPlayerName(playerid, PlayerName, 30);
				printf("[Command] %s has used /akill to kill %s", PlayerName, giveplayer);
				return 1;
			}
			else
			{
			    format(string, sizeof(string), "%d is not an active player.", giveplayerid);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
 			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
 			return 1;
		}
	}

// === [Admins] ===
	if(!strcmp(cmdtext, "/admins", true))
	{
		new count=0;
		for(new i=0; i<MAX_PLAYERS; i++)
		{
	    	if(IsPlayerConnected(i))
	    	{
				if(PlayerInfo[i][pAdmin] >= 1)
				{
					new str[256];
					new pname[24];
					SendClientMessage(playerid, COLOR_BLUE, "Checking for administrators online...");
					GetPlayerName(i, pname, 24);
					format(str, 256, "Administrator %s", pname);
					SendClientMessage(playerid, COLOR_RED, str);
					count++;
				}
			}
		}
		if(count == 0)
		{
		    SendClientMessage(playerid, COLOR_BLUE, "Checking for administrators online...");
	    	SendClientMessage(playerid, COLOR_RED, "There aren't any administrators online on the server!");
		}
		return 1;
	}
// === [Tele] ===
	if(strcmp(cmd, "/tele", true) == 0)
	{
		new telename[MAX_PLAYER_NAME];
		new teleid;
		new Float:pX, Float:pY, Float:pZ;
		tmp = strtok(cmdtext, idx);
		GetPlayerName(playerid, sendername, sizeof(sendername));
		PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You must be logged in to use this command!");
			return 1;
		}
		if(PlayerInfo[playerid][pAdmin] == 0)
		{
		    SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		    return 1;
		}
		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "USAGE: /tele [teleportee id] [destination id]");
			return 1;
		}
		giveplayerid = strval(tmp);

		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "USAGE: /tele [teleportee id] [destination id]");
			return 1;
		}
 		teleid = strval(tmp);
        if(PlayerInfo[playerid][pAdmin] == 2 || PlayerInfo[playerid][pAdmin] == 3  || PlayerInfo[playerid][pAdmin] == 4)
        {
            if(IsPlayerConnected(giveplayerid) && IsPlayerConnected(teleid))
            {
            	GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
				GetPlayerName(playerid, sendername, sizeof(sendername));
				GetPlayerName(teleid, telename, sizeof(telename));
				GetPlayerPos(teleid, pX,pY,pZ);
				SetPlayerPos(giveplayerid, pX,pY,pZ);
				format(string, sizeof(string), "AdmCMD: You teleported %s to %s.", giveplayer,telename);
				SendClientMessage(playerid, COLOR_BLUE, string);
				format(string, sizeof(string), "AdmCMD: You have been teleported to %s by Admin %s.", telename,sendername);
				SendClientMessage(giveplayerid, COLOR_BLUE, string);
				new PlayerName[24];
				GetPlayerName(playerid, PlayerName, 30);
				printf("[Command] %s has used /tele to tele %s to %s", PlayerName, giveplayer, telename);
				return 1;
			}
			else
			{
				if(!IsPlayerConnected(giveplayerid))
				{
					format(string, sizeof(string), "ID:%d is not an active player ID number.", giveplayerid);
					SendClientMessage(playerid, COLOR_RED, string);
				}
				if(!IsPlayerConnected(teleid))
				{
					format(string, sizeof(string), "ID:%d is not an active player ID number.", teleid);
					SendClientMessage(playerid, COLOR_RED, string);
				}
			}
		}
		else
		{
	 		SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
		}
		return 1;
	}
// === [A] ===
	if(strcmp(cmd, "/a", true) == 0 || strcmp(cmd, "/admin", true) == 0 || strcmp(cmd, "/achat", true) == 0)
	{
		GetPlayerName(playerid, sendername, sizeof(sendername));
		new length = strlen(cmdtext);
		while ((idx < length) && (cmdtext[idx] <= ' '))
		{
			idx++;
		}
		new offset = idx;
		new result[64];
		while ((idx < length) && ((idx - offset) < (sizeof(result) - 1)))
		{
			result[idx - offset] = cmdtext[idx];
			idx++;
		}
		result[idx - offset] = EOS;
		if(!strlen(result))
		{
			SendClientMessage(playerid, COLOR_GREY, "USAGE: /a [text] [admin chat]");
			return 1;
		}
		if(IsPlayerAdmin(playerid) || PlayerInfo[playerid][pAdmin] >= 1)
		{
			format(string, sizeof(string), "(( Admin Chat %s: %s ))", sendername, result);
			SendMessageToAdmins(COLOR_BLUE,string);
            return 1;
		}
		else
		{
			SendClientMessage(playerid, COLOR_RED, "You aren't able to use administration chat!");
            return 1;
		}
	}


// === [Clearchat] ===
	if(strcmp(cmdtext, "/clearchat", true) == 0)
	{
		if(PlayerInfo[playerid][pAdmin] == 1 || PlayerInfo[playerid][pAdmin] == 2 || PlayerInfo[playerid][pAdmin] == 3)
		{
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			SendClientMessageToAll(COLOR_SYSTEM, " ");
			GameTextForAll("Chat cleared!", 1000,1);
			new PlayerName[30];
			GetPlayerName(playerid, PlayerName, 30);
			printf("[Command] %s has used /clearchat", PlayerName);
			return 1;
		}
		else
		{
 			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
			return 1;
		}
	}

// === [Disarm] ===
	if(strcmp(cmd, "/disarm", true) == 0)
	{
		tmp = strtok(cmdtext, idx);
		giveplayerid = strval(tmp);
		GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
        PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
        PlayerInfo[giveplayerid][pAdmin] = dini_Int(udb_encode(giveplayer), "level");
        if(IsStringAName(tmp))
		{
			giveplayerid = GetPlayerID(tmp);
		}
		else
		{
			giveplayerid = strval(tmp);
		}
		if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You must be logged in to use this command!");
			return 1;
		}
		if(!strlen(tmp) && PlayerInfo[playerid][pAdmin] >= 1)
		{
			SendClientMessage(playerid, COLOR_DBLUE, "USAGE: /disarm [playerid]");
			return 1;
		}
		if(PlayerInfo[playerid][pAdmin] >= 3)
		{
		    if(IsPlayerConnected(giveplayerid))
			{
				GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
				GetPlayerName(playerid, sendername, sizeof(sendername));
				ResetPlayerWeapons(giveplayerid);
				format(string, sizeof(string), "AdmCMD: Admin %s has disarmed %s.", sendername,giveplayer);
				SendClientMessageToAll(COLOR_BLUE, string);
				format(string, sizeof(string), "AdmCMD: Admin %s disarmed you.", sendername);
				SendClientMessage(giveplayerid, COLOR_BLUE, string);
				new PlayerName[30];
				GetPlayerName(playerid, PlayerName, 30);
				printf("[Command] %s has used /disarm to disarm %s", PlayerName, giveplayer);
			}
			else
			{
   				format(string, sizeof(string), "%d is not an active player ID number.", giveplayerid);
				SendClientMessage(playerid, COLOR_RED, string);
			}
		}
		else
		{
			SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
			return 1;
		}
		return 1;
	}
	if(strcmp(cmd, "/disarmall", true) == 0)
	{
	    GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));
        PlayerInfo[playerid][pAdmin] = dini_Int(udb_encode(sendername), "level");
        if(logged[playerid] == 0)
		{
			SendClientMessage(playerid, COLOR_RED, "You must be logged in to use this command!");
			return 1;
		}
		if(PlayerInfo[playerid][pAdmin] >= 3)
		{
		    for(new i = 0; i < MAX_PLAYERS; i ++)
			{
	  			if(IsPlayerConnected(i))
				{
					ResetPlayerWeapons(i);
					format(string, sizeof(string), "AdmCMD: Admin %s has disarmed everyone.", sendername);
					SendClientMessage(i, COLOR_BLUE, string);
					new PlayerName[30];
					GetPlayerName(playerid, PlayerName, 30);
					printf("[Command] %s has used /disarmall to disarm everyone", PlayerName);
				}
			}
		}
		else
		{
		    SendClientMessage(playerid, COLOR_RED, "You do not have permission to use that command!");
			return 1;
		}
		return 1;
	}
		
	return 0;
}

public IsStringAName(string[])
{
	for(new i = 0; i <= MAX_PLAYERS; i++)
	{
	if(IsPlayerConnected(i) == 1)
	{
		new testname[MAX_PLAYER_NAME];
		GetPlayerName(i, testname, sizeof(testname));
		if(strcmp(testname, string, true, strlen(string)) == 0)
		{
			return 1;
		}
	}
}
	return 0;
}
public GetPlayerID(string[])
{
	for(new i = 0; i <= MAX_PLAYERS; i++)
	{
	if(IsPlayerConnected(i) == 1)
	{
		new testname[MAX_PLAYER_NAME];
		GetPlayerName(i, testname, sizeof(testname));
		if(strcmp(testname, string, true, strlen(string)) == 0)
		{
			return i;
		}
	}
}
	return INVALID_PLAYER_ID;
}
public SendMessageToAdmins(color,const string[])
{
	for(new i = 0; i <= MAX_PLAYERS; i++)
	{
		if(IsPlayerConnected(i) == 1)
		{
			if (IsPlayerAdmin(i) || PlayerInfo[i][pAdmin] >= 1)
			{
				SendClientMessage(i, color, string);
			}
		}
	}
	return 1;
}
public Restart()
{
    SendRconCommand("gmx");
}

